<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class ProductComposition extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_composition_master';
    }

	public function rules() {
        return [
            [['composition', 'status'], 'required'],
            [['composition'], 'unique'],
			[['composition', 'status'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'composition' => 'Composition',
            'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach ProductComposition data and listing
    public function search($params) {
		$query = ProductComposition::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'name_of_company', $this->name]);
		$query->andFilterWhere(['like', 'email_id', $this->email_id]);
		
        return $dataProvider;
    }

}
