<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class ProductCategory extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_product_category_master';
    }

	public function rules() {
        return [
            [['product_category', 'status'], 'required'],
            [['product_category'], 'unique'],
			[['product_category', 'status'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'product_category' => 'Product Category',
			'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach ProductCategory data and listing
    public function search($params) {
		$query = ProductCategory::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'product_category', $this->product_category]);
		$query->andFilterWhere(['like', 'status', $this->status]);
		
        return $dataProvider;
    }

}
