<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class Ownmaster extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_own_master_data_module';
    }

	public function rules() {
        return [
            [['name_of_company', 'address', 'email_id', 'contact_no', 'state_code', 'gst_applicable', 'is_licenses_applicable', 'is_primary_company'], 'required'],
			[['email_id'], 'email'],
			[['email_id'], 'unique'],
			[['contact_no'], 'number'],
			[['name_of_company', 'address', 'email_id', 'contact_no', 'state_code', 'gst_applicable', 'is_licenses_applicable', 'number_of_licenses', 'is_primary_company', 'password', 'confirm_password', 'bank_name', 'account_no', 'ifsc_code', 'branch_name', 'licenses_number1', 'licenses_number2', 'licenses_number3', 'licenses_number4', 'gst_no', 'invoice_design', 'invoice_series', 'is_logo', 'logo_type', 'logo_text', 'logo_file', 'user_id', 'alt_contact_no'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'name_of_company' => 'Name of Company',
            'address' => 'Address',
            'email_id' => 'Email Id',
            'contact_no' => 'Contact Number',
            'alt_contact_no' => 'Alternate Contact Number',
            'state_code' => 'State Name',
			'gst_applicable' => 'Is GST Applicable',
			'is_licenses_applicable' => 'Is Licenses Applicable',
            'gst_no' => 'GST Number',
            'books_name' => 'Books Name (Short Name)',
            'name_of_license_one' => 'Name of License 1',
            'number_of_license_one' => 'Number of License 1',
			'name_of_license_two' => 'Name of License 2',
            'number_of_license_two' => 'Number of License 2',
			'name_of_license_three' => 'Name of License 3',
            'number_of_license_three' => 'Number of License 3',
			'name_of_license_four' => 'Name of License 4',
            'number_of_license_four' => 'Number of License 4',
            'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach ownmaster data and listing
    public function search($params) {
		$query = Ownmaster::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'name_of_company', $this->name]);
		$query->andFilterWhere(['like', 'email_id', $this->email_id]);
		$query->andFilterWhere(['like', 'contact_no', $this->contact_no]);
		$query->andFilterWhere(['like', 'address', $this->address]);
		
        return $dataProvider;
    }

}
