<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class LicensesMaster extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_licenses_master';
    }

	
    public function rules() {
        return [
            [['number_of_license', 'status'], 'required'],
			[['number_of_license', 'status', 'license_one', 'license_two', 'license_three', 'license_four'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'number_of_license' => 'Number of License',
            'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach LicensesMaster data and listing
    public function search($params) {
		$query = LicensesMaster::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'number_of_license', $this->number_of_license]);
		$query->andFilterWhere(['like', 'status', $this->status]);
		
        return $dataProvider;
    }

}
