<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class FarmingTypeMaster extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_farming_type_master';
    }

	public function rules() {
        return [
            [['name_of_farming_type', 'status'], 'required'],
			[['name_of_farming_type', 'status'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'name_of_farming_type' => 'Name of Farming Type',
            'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach FarmingTypeMaster data and listing
    public function search($params) {
		$query = FarmingTypeMaster::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'name_of_company', $this->name]);
		$query->andFilterWhere(['like', 'email_id', $this->email_id]);
		
        return $dataProvider;
    }

}
