<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class FarmerMaster extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_farmer_master';
    }

	public function rules() {
        return [
            [['name_of_farmer', 'farmer_type', 'area_id', 'space', 'contact_no', 'address', 'status'], 'required'],
			[['name_of_farmer', 'farmer_type', 'image', 'area_id', 'space', 'contact_no', 'address', 'status'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'name_of_farmer' => 'Name of Farmer',
            'address' => 'Address',
            'farmer_type' => 'Farmer Type',
            'contact_no' => 'Contact Number',
            'area_id' => 'Area',
            'space' => 'Space',
			'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach FarmerMaster data and listing
    public function search($params) {
		$query = FarmerMaster::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'name_of_farmer', $this->name_of_farmer]);
		$query->andFilterWhere(['like', 'farmer_type', $this->farmer_type]);
		$query->andFilterWhere(['like', 'contact_no', $this->contact_no]);
		$query->andFilterWhere(['like', 'address', $this->address]);
		
        return $dataProvider;
    }
	
	public function getAllFarmerData($keyword){
		$connection = \Yii::$app->db;
		if(!empty($keyword)){
			$sql = "select * from map_farmer_master where status = 'Active' and (name_of_farmer like '%$keyword%' OR farmer_type like '%$keyword%' OR contact_no like '%$keyword%')";
			$command = $connection->createCommand($sql);
			$data = $command->queryAll();
			return $data;
		}else{
			$sql = "select * from map_farmer_master where status = 'Active'";
			$command = $connection->createCommand($sql);
			$data = $command->queryAll();
			return $data;
		}
	}
	
	public function getFarmerType(){
		$connection = \Yii::$app->db;
		$sql = "select id,name_of_farming_type from map_farming_type_master where status = 'Active'";
		$command = $connection->createCommand($sql);
		$data = $command->queryAll();
		$array = array();
		$array = array(""=>"Select Farmer Type");
		if(!empty($data)){
			foreach($data as $value){
				$array[$value['id']] = $value['name_of_farming_type'];
			}
		}
		return $array;
	}
	
	public function getFarmerTypeName($id){
		$connection = \Yii::$app->db;
		$sql = "select name_of_farming_type from map_farming_type_master where id = :id";
		$command = $connection->createCommand($sql);
		$command = $command->bindParam(":id", $id);
		$data = $command->queryAll();
		return !empty($data[0]['name_of_farming_type']) ? $data[0]['name_of_farming_type'] : '';
	}

}
