<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class ExpensesMaster extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_expenses_master';
    }

	public function rules() {
        return [
            [['name_of_expenses', 'expenses_related_to', 'status'], 'required'],
			[['name_of_expenses', 'expenses_related_to', 'status'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'name_of_expenses' => 'Name of Expenses',
            'expenses_related_to' => 'Expenses Related To',
            'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach ExpensesMaster data and listing
    public function search($params) {
		$query = ExpensesMaster::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'expenses_related_to', $this->expenses_related_to]);
		$query->andFilterWhere(['like', 'name_of_expenses', $this->name_of_expenses]);
		$query->andFilterWhere(['like', 'status', $this->status]);
		
        return $dataProvider;
    }

}
