<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class Expenses extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_expenses';
    }

	public function rules() {
        return [
            [['expenses_id', 'amount', 'sr_no', 'date', 'status'], 'required'],
			[['expenses_id', 'amount', 'remarks', 'date', 'sr_no', 'status'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'expenses_id' => 'Expenses Name',
            'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach Expenses data and listing
    public function search($params) {
		$query = Expenses::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'sr_no', $this->sr_no]);
		$query->andFilterWhere(['like', 'date', $this->date]);
		$query->andFilterWhere(['like', 'amount', $this->amount]);
		$query->andFilterWhere(['like', 'status', $this->status]);
		
        return $dataProvider;
    }
	
	// For get expenses data
	public function getExpenses(){
		$connection = \Yii::$app->db;	
		$sql = "select id,name_of_expenses from map_expenses_master where status = 'Active'";
		$command = $connection->createCommand($sql);
		$data = $command->queryAll();
		$array = array();
		$array = array(""=>"Select Expenses");
		if(!empty($data)){
			foreach($data as $value){
				$array[$value['id']] = $value['name_of_expenses'];
			}
		}
		return $array;
	}
	
	// For get expenses name
	public function getExpenseName($id){
		$connection = \Yii::$app->db;	
		$sql = "select name_of_expenses from map_expenses_master where id = :id";
		$command = $connection->createCommand($sql);
		$command = $command->bindParam(":id", $id);
		$data = $command->queryAll();
		if(!empty($data[0]['name_of_expenses'])){
			return $data[0]['name_of_expenses'];
		}
	}

}
