<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class Driver extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_driver';
    }

	public function rules() {
        return [
            [['name', 'driving_license_number', 'contact_number', 'status'], 'required'],
			[['name', 'driving_license_number', 'contact_number', 'status'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'name' => 'Name',
            'driving_license_number' => 'Driving License Number',
            'contact_number' => 'Contact Number',
			'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach Driver data and listing
    public function search($params) {
		$query = Driver::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'name', $this->name]);
		$query->andFilterWhere(['like', 'contact_number', $this->contact_number]);
		$query->andFilterWhere(['like', 'driving_license_number', $this->driving_license_number]);
		$query->andFilterWhere(['like', 'status', $this->status]);
		
        return $dataProvider;
    }

}
