<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class CustomerMaster extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_customer_master';
    }

	public function rules() {
        return [
            [['name', 'address', 'email_id', 'contact_no', 'area_id', 'gst_applicable', 'is_licenses_applicable', 'customer_type', 'aadhaar_card_no', 'pan_card_no', 'staff_assign_id', 'opening_balance', 'password', 'confirm_password', 'whatsapp_contact_no'], 'required'],
			[['email_id'], 'email'],
			[['aadhaar_card_no'], 'unique'],
			[['pan_card_no'], 'unique'],
			[['email_id'], 'unique'],
			[['contact_no'], 'number'],
			[['whatsapp_contact_no', 'aadhaar_card_no', 'pan_card_no'], 'number'],
			['confirm_password', 'compare', 'compareAttribute'=>'password', 'message'=>"Passwords do not match" ],
			[['name', 'address', 'email_id', 'contact_no', 'area_id', 'gst_applicable', 'is_licenses_applicable', 'customer_type', 'aadhaar_card_no', 'pan_card_no', 'staff_assign_id', 'opening_balance', 'password', 'confirm_password', 'whatsapp_contact_no', 'license_no', 'gst_no', 'customer_code', 'maximum_limit', 'vegetable', 'clothing', 'power_to_join_farmer', 'status'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'name' => 'Customer Name',
            'address' => 'Address',
            'staff_assign_id' => 'Assign Staff',
            'email_id' => 'Email Id',
            'contact_no' => 'Contact Number',
            'whatsapp_contact_no' => 'WhatsApp Contact Number',
            'area_id' => 'Area',
			'gst_applicable' => 'Is GST Applicable',
			'is_licenses_applicable' => 'Is Licenses Applicable',
            'gst_no' => 'GST Number',
            'license_no' => 'Licenses Number',
            'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach CustomerMaster data and listing
    public function search($params) {
		$query = CustomerMaster::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'name', $this->name]);
		$query->andFilterWhere(['like', 'email_id', $this->email_id]);
		$query->andFilterWhere(['like', 'contact_no', $this->contact_no]);
		$query->andFilterWhere(['like', 'aadhaar_card_no', $this->aadhaar_card_no]);
		$query->andFilterWhere(['like', 'pan_card_no', $this->pan_card_no]);
		
        return $dataProvider;
    }
	
	public function getCustomerType(){
		$connection = \Yii::$app->db;
		$sql = "select id,name_of_customer_type from map_customer_type_master where status = 'Active'";
		$command = $connection->createCommand($sql);
		$data = $command->queryAll();
		$array = array();
		$array = array(""=>"Select Customer Type");
		if(!empty($data)){
			foreach($data as $value){
				$array[$value['id']] = $value['name_of_customer_type'];
			}
		}
		return $array;
	}
	
	public function getAllCustomers(){
		$connection = \Yii::$app->db;
		$sql = "select id,name from map_customer_master where status = 'Active'";
		$command = $connection->createCommand($sql);
		$data = $command->queryAll();
		$array = array();
		$array = array(""=>"Select Customer Name");
		if(!empty($data)){
			foreach($data as $value){
				$array[$value['id']] = $value['name'];
			}
		}
		return $array;
	}
	
	public function getAllBanks(){
		$connection = \Yii::$app->db;
		$sql = "select id,bank_name from map_bank_master where status = 'Active'";
		$command = $connection->createCommand($sql);
		$data = $command->queryAll();
		$array = array();
		$array = array(""=>"Select Bank");
		if(!empty($data)){
			foreach($data as $value){
				$array[$value['id']] = $value['bank_name'];
			}
		}
		return $array;
	}
	
	public function getCustomerTypeName($id){
		$connection = \Yii::$app->db;
		$sql = "select name_of_customer_type from map_customer_type_master where id = :id";
		$command = $connection->createCommand($sql);
		$command = $command->bindParam(":id", $id);
		$data = $command->queryAll();
		return !empty($data[0]['name_of_customer_type']) ? $data[0]['name_of_customer_type'] : '';
	}
	
	public function getSearchCustData($keywords){
		$connection = \Yii::$app->db;
		$sql = "select * from map_customer_master where status = 'Active' and (name like '%$keywords%' or customer_code like '%$keywords%' or email_id like '%$keywords%' or contact_no like '%$keywords%')";
		$command = $connection->createCommand($sql);
		$data = $command->queryAll();
		return $data;
	}
	
	public function getAllCustData($page,$page_records){
		$connection = \Yii::$app->db;
		$start = $page_records * ($page - 1);
		$end = $page_records;
		$sql = "select * from map_customer_master where status = 'Active' limit :start,:end";
		$command = $connection->createCommand($sql);
		$command = $command->bindParam(":start", $start);
		$command = $command->bindParam(":end", $end);
		$data = $command->queryAll();
		return $data;
	}

}
