<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class Cdrate extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_cd_rate_master';
    }

	public function rules() {
        return [
            [['cd_rate', 'validity_from', 'validity_to', 'conditions', 'status'], 'required'],
			[['cd_rate', 'validity_from', 'validity_to', 'conditions', 'status'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'cd_rate' => 'Cd Rate',
            'validity_from' => 'Validity From',
            'validity_to' => 'Validity To',
            'conditions' => 'Conditions',
            'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach Cdrate data and listing
    public function search($params) {
		$query = Cdrate::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'cd_rate', $this->cd_rate]);
		$query->andFilterWhere(['like', 'validity_to', $this->validity_to]);
		$query->andFilterWhere(['like', 'validity_from', $this->validity_from]);
		$query->andFilterWhere(['like', 'conditions', $this->conditions]);
		
        return $dataProvider;
    }

}
