<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class CaseInHand extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_case_in_hand_master';
    }

	public function rules() {
        return [
            [['name', 'opening_balance', 'status', 'related_to'], 'required'],
			[['name', 'opening_balance', 'status', 'related_to'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'name_of_brand' => 'Name of Brand',
			'related_to' => 'Related To',
			'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach CaseInHand data and listing
    public function search($params) {
		$query = CaseInHand::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'name_of_brand', $this->name_of_brand]);
		$query->andFilterWhere(['like', 'related_to', $this->related_to]);
		
        return $dataProvider;
    }

}
