<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class BooksMaster extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_book_master';
    }

	public function rules() {
        return [
            [['name_of_books', 'address', 'state_name', 'status'], 'required'],
            [['name_of_books'], 'unique'],
			[['name_of_books', 'address', 'state_name', 'status'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'name_of_books' => 'Name of Books',
            'address' => 'Address',
            'state_name' => 'State Name',
			'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach BooksMaster data and listing
    public function search($params) {
		$query = BooksMaster::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'name_of_books', $this->name_of_books]);
		$query->andFilterWhere(['like', 'state_name', $this->state_name]);
		$query->andFilterWhere(['like', 'address', $this->address]);
		$query->andFilterWhere(['like', 'status', $this->status]);
		
        return $dataProvider;
    }

}
