<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class BankMaster extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_bank_master';
    }

	public function rules() {
        return [
            [['bank_name', 'account_no', 'ifsc_code', 'branch_name', 'bank_related_to', 'opening_balance', 'status'], 'required'],
			[['bank_name', 'account_no', 'ifsc_code', 'branch_name', 'bank_related_to', 'opening_balance', 'status'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'bank_name' => 'Bank Name',
            'account_no' => 'Account Number',
            'ifsc_code' => 'IFSC Code',
            'branch_name' => 'Branch Name',
            'bank_related_to' => 'Bank Related To',
            'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach BankMaster data and listing
    public function search($params) {
		$query = BankMaster::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'bank_name', $this->bank_name]);
		$query->andFilterWhere(['like', 'ifsc_code', $this->ifsc_code]);
		$query->andFilterWhere(['like', 'status', $this->status]);
		$query->andFilterWhere(['like', 'branch_name', $this->branch_name]);
		$query->andFilterWhere(['like', 'bank_related_to', $this->bank_related_to]);
		$query->andFilterWhere(['like', 'opening_balance', $this->opening_balance]);
		$query->andFilterWhere(['like', 'account_no', $this->account_no]);
		
        return $dataProvider;
    }

}
