<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class Areamaster extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_area_master';
    }

	public function rules() {
        return [
            [['name_of_master', 'applicable_to', 'status'], 'required'],
			[['name_of_master', 'applicable_to', 'status'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'name_of_master' => 'Name of master',
            'applicable_to' => 'Applicable To',
            'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach areamaster data and listing
    public function search($params) {
		$query = Areamaster::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'name_of_master', $this->name_of_master]);
		$query->andFilterWhere(['like', 'applicable_to', $this->applicable_to]);
		$query->andFilterWhere(['like', 'status', $this->status]);
		
        return $dataProvider;
    }

}
