<?php
namespace backend\controllers;

use Yii;
use yii\web\NotFoundHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\helpers\Security;
use common\models\User;
use backend\models\VehicleNumber;
use backend\models\Utility;

/**
 * VehicleNumber controller
 */
class VehicleNumberController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['update', 'index', 'create'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                // 'actions' => [
                    // 'logout' => ['post'],
                // ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    /**
     * Displays VehicleNumber listing.
     *
     * @return string
     */
    public function actionIndex(){
        $searchModel = new VehicleNumber();
		$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
		
        return $this->render('index', [
				'searchModel' => $searchModel,
				'dataProvider' => $dataProvider
		]);
    }
	
	// For create VehicleNumber
	public function actionCreate(){
		$model = new VehicleNumber();
		$drivers = $model->getDrivers();
		$owners = $model->getVehicleOwner();
		if(!empty($_POST['VehicleNumber'])){
			$model->attributes = $_POST['VehicleNumber'];
			$model->created_on = new \yii\db\Expression('now()');
			$model->created_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/vehicle-number']);
			}
		}		
        return $this->render('create', [
				'model' => $model,
				'drivers' => $drivers,
				'owners' => $owners,
		]);
    }
	
	
	// For update VehicleNumber data
	public function actionUpdate($id=''){
		$model = $this->findModel($id);
		$modelV = new VehicleNumber();
		$drivers = $modelV->getDrivers();
		$owners = $modelV->getVehicleOwner();
		if(!empty($_POST['VehicleNumber'])){
			$model->attributes = $_POST['VehicleNumber'];
			$model->updated_on = new \yii\db\Expression('now()');
			$model->updated_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/vehicle-number']);
			}
		}
		return $this->render('update', [
				'model' => $model,
				'drivers' => $drivers,
				'owners' => $owners,
				'id' => $id
		]);
    }
	
	// For get VehicleNumber data from id
	protected function findModel($id) {
        if (($model = VehicleNumber::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

}
