<?php
namespace backend\controllers;

use Yii;
use yii\web\NotFoundHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\helpers\Security;
use common\models\User;
use backend\models\StaffMaster;
use backend\models\Utility;

/**
 * StaffMaster controller
 */
class StaffMasterController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['update', 'index', 'create'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                // 'actions' => [
                    // 'logout' => ['post'],
                // ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    /**
     * Displays StaffMaster listing.
     *
     * @return string
     */
    public function actionIndex(){
        $searchModel = new StaffMaster();
		$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
		
        return $this->render('index', [
				'searchModel' => $searchModel,
				'dataProvider' => $dataProvider
		]);
    }
	
	// For create StaffMaster
	public function actionCreate(){
		$model = new StaffMaster();
		$companyData = $model->getCompanyData();
		$areaData = $model->getAreaData();
		if(!empty($_POST['StaffMaster'])){
			$model->attributes = $_POST['StaffMaster'];
			
			$email = !empty($_POST['StaffMaster']['email_id']) ? $_POST['StaffMaster']['email_id'] : '';
			$userData = User::find()->where(['email' => $email, 'user_type' => 2])->one();
			if(empty($userData)){			
				$userModel = new User();
				$pass = !empty($_POST['StaffMaster']['password']) ? $_POST['StaffMaster']['password'] : '';
				$userModel->password_hash = Security::generatePasswordHash($pass);
				$userModel->new_password_hash = $userModel->password_hash;
				$userModel->confirm_password_hash = $userModel->password_hash;
				$userModel->auth_key = $userModel->password_hash;
				$userModel->email = $email;
				$userModel->user_type = 2;
				$userModel->status = 'Active';
				$userModel->created_at = new \yii\db\Expression('now()');
				$userModel->created_by = Yii::$app->user->identity->id;
				$userModel->save();
				
				$model->password = $userModel->password_hash;
				$model->confirm_password = $userModel->password_hash;
				$model->user_id = $userModel->id;
				$model->created_on = new \yii\db\Expression('now()');
				$model->created_by = Yii::$app->user->identity->id;
				$model->staff_rights = !empty($_POST['StaffMaster']['staff_rights']) ? implode(",", $_POST['StaffMaster']['staff_rights']) : '';
				$model->photo = !empty($_POST['upload_file']) ? $_POST['upload_file'] : '';
				if ($model->validate()) {
					$model->save();
					return $this->redirect(['/staff-master']);
				}
			}else{
				$error = "Email id is already exist.";
				return $this->render('create', [
						'model' => $model,
						'companyData' => $companyData,
						'areaData' => $areaData,
						'error' => $error
				]);
			}
		}		
        return $this->render('create', [
				'model' => $model,
				'companyData' => $companyData,
				'areaData' => $areaData
		]);
    }
	
	
	// For update StaffMaster data
	public function actionUpdate($id=''){
		$model = $this->findModel($id);
		$modelS = new StaffMaster();
		$companyData = $modelS->getCompanyData();
		$areaData = $modelS->getAreaData();
		$model->staff_rights = !empty($model->staff_rights) ? explode(",", $model->staff_rights) : '';
		if(!empty($_POST['StaffMaster'])){
			$model->attributes = $_POST['StaffMaster'];
			
			$email = !empty($_POST['StaffMaster']['email_id']) ? $_POST['StaffMaster']['email_id'] : '';
			$userModel = User::find()->where(['email' => $email, 'user_type' => 2])->one();
			if(!empty($userModel)){			
				$newPassword = !empty($_POST['StaffMaster']['password']) ? $_POST['StaffMaster']['password'] : '';
				if($newPassword != $userModel->password_hash){
					$userModel->password_hash = Security::generatePasswordHash($newPassword);
					$userModel->new_password_hash = $userModel->password_hash;
					$userModel->confirm_password_hash = $userModel->password_hash;
					$userModel->auth_key = $userModel->password_hash;
					$userModel->updated_at = new \yii\db\Expression('now()');
					$userModel->updated_by = Yii::$app->user->identity->id;
					$userModel->save();
					
					$model->password = $userModel->password_hash;
					$model->confirm_password = $userModel->password_hash;
				}
			}

			$model->staff_rights = !empty($_POST['StaffMaster']['staff_rights']) ? implode(",", $_POST['StaffMaster']['staff_rights']) : '';
			$model->photo = !empty($_POST['upload_file']) ? $_POST['upload_file'] : '';
			$model->updated_on = new \yii\db\Expression('now()');
			$model->updated_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/staff-master']);
			}
		}
		return $this->render('update', [
				'model' => $model,
				'companyData' => $companyData,
				'areaData' => $areaData,
				'id' => $id
		]);
    }
	
	// For get StaffMaster data from id
	protected function findModel($id) {
        if (($model = StaffMaster::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

}
