<?php
namespace backend\controllers;

use Yii;
use yii\web\NotFoundHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use common\models\LoginForm;
use yii\helpers\Security;
use common\models\User;
use backend\models\Utility;

/**
 * Site controller
 */
class SiteController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error', 'forgotpass'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['logout', 'index', 'changepassword'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                // 'actions' => [
                    // 'logout' => ['post'],
                // ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    /**
     * Displays homepage.
     *
     * @return string
     */
    public function actionIndex()
    {
        return $this->render('index');
    }

    /**
     * Login action.
     *
     * @return string
     */
    public function actionLogin(){
		$this->layout = 'login';
        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $model = new LoginForm();
        if ($model->load(Yii::$app->request->post()) && $model->login(1)) {
            $url = BASE_URL.'dashboard';
			$this->redirect($url);
        } else {
            $model->password = '';

            return $this->render('login', [
                'model' => $model,
            ]);
        }
    }
	
	public function actionForgotpass(){
		$this->layout = 'login';
        $model = new LoginForm();
		$data = Yii::$app->request->post();
		$error = '';
		if(!empty($data['LoginForm']['email'])){
			$email_id = $data['LoginForm']['email'];
			$model2 = User::find()->where(['email' => $email_id])->one();
			
			if(!empty($model2)){
				$newPassword = Utility::randomString(10);
				$model2->password_hash = Security::generatePasswordHash($newPassword);
                $model2->new_password_hash = $model2->password_hash;
                $model2->confirm_password_hash = $model2->password_hash;
                $model2->updated_at = date("Y-m-d H:i:s");
                if ($model2->save()) {
					// For send email
					$to_name = ''; 
					$subject = 'Password Details - Maprole';
					$message = 'Dear '.$email_id;
					$message .= '<br><p>Your password has been changed, Please login with the following details :- <p>';
					$message .= '<p>Login Url:- '.BASE_URL.'login<p>';
					$message .= '<p>Email Id :- '.$email_id.'<p>';
					$message .= '<p>Password :- '.$newPassword.'<p>';
					$message .= '<br><p>Thanks & Regards,<br> Maprole Team<p>';
					Utility::sendEmail($email_id,$to_name,$subject,$message);
                    $error = 'Password details has been sent to your registered email, Please check email for more details.';
                }
			}else{
				$error = 'Email id is not registered.';
			}
		}
		
        return $this->render('forgotpass', [
			'model' => $model,
			'error' => $error
		]);
    }

    /**
     * Logout action.
     *
     * @return string
     */
    public function actionLogout(){
        Yii::$app->user->logout();

        return $this->goHome();
    }
	
	// For change user password
	public function actionChangepassword() {
        $error = '';
        $model = User::findOne(\Yii::$app->user->id);
        if ($model->load($_POST)) {
            if (Security::validatePassword($_POST['User']['old_password_hash'], $model->password_hash)) {
                $model->password_hash = Security::generatePasswordHash($_POST['User']['new_password_hash']);
                $model->new_password_hash = $model->password_hash;
                $model->confirm_password_hash = $model->password_hash;
                if ($model->save()) {
                    $error = 'Password changed successfully';
                }
            } else {
                $error = 'Unable to verify old password, please try again';
            }
        }

        $model->old_password_hash = '';
        $model->new_password_hash = '';
        $model->confirm_password_hash = '';

        return $this->render('changepassword', [
                    'model' => $model,
                    'error' => $error,
        ]);
    }
	
}
