<?php
namespace backend\controllers;

use Yii;
use yii\web\NotFoundHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\helpers\Security;
use common\models\User;
use backend\models\Scheme;
use backend\models\ProductOf;
use backend\models\Utility;

/**
 * Scheme controller
 */
class SchemeController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['update', 'index', 'create'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                // 'actions' => [
                    // 'logout' => ['post'],
                // ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    /**
     * Displays Scheme listing.
     *
     * @return string
     */
    public function actionIndex(){
        $searchModel = new Scheme();
		$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
		
        return $this->render('index', [
				'searchModel' => $searchModel,
				'dataProvider' => $dataProvider
		]);
    }
	
	// For create Scheme
	public function actionCreate(){
		$model = new Scheme();
		$modelProduct = new ProductOf();
		$productsData = $modelProduct->getProducts();
		if(!empty($_POST['Scheme'])){
			$model->attributes = $_POST['Scheme'];
			$model->created_on = new \yii\db\Expression('now()');
			$model->created_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/scheme']);
			}
		}		
        return $this->render('create', [
				'model' => $model,
				'productsData' => $productsData
		]);
    }
	
	
	// For update Scheme data
	public function actionUpdate($id=''){
		$model = $this->findModel($id);
		$modelProduct = new ProductOf();
		$productsData = $modelProduct->getProducts();
		if(!empty($_POST['Scheme'])){
			$model->attributes = $_POST['Scheme'];
			$model->updated_on = new \yii\db\Expression('now()');
			$model->updated_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/scheme']);
			}
		}
		return $this->render('update', [
				'model' => $model,
				'productsData' => $productsData,
				'id' => $id
		]);
    }
	
	// For get Scheme data from id
	protected function findModel($id) {
        if (($model = Scheme::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

}
