<?php
namespace backend\controllers;

use Yii;
use yii\web\NotFoundHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\helpers\Security;
use common\models\User;
use backend\models\Sales;
use backend\models\ProductOf;
use backend\models\Utility;

/**
 * Sales controller
 */
class SalesController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['update', 'index', 'create'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                // 'actions' => [
                    // 'logout' => ['post'],
                // ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    /**
     * Displays Sales listing.
     *
     * @return string
     */
    public function actionIndex(){
        $searchModel = new Sales();
        $modelBook = new ProductOf();
		$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
		
        return $this->render('index', [
				'searchModel' => $searchModel,
				'modelBook' => $modelBook,
				'dataProvider' => $dataProvider
		]);
    }
	
	// For create Sales
	public function actionCreate(){
		$model = new Sales();
		$modelProduct = new ProductOf();
		$booksData = $modelProduct->getBooks();
		$productsData = $modelProduct->getProducts();
		if(!empty($_POST['Sales'])){
			$model->attributes = $_POST['Sales'];
			$model->created_on = new \yii\db\Expression('now()');
			$model->created_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/sales']);
			}
		}		
        return $this->render('create', [
				'model' => $model,
				'productsData' => $productsData,
				'booksData' => $booksData
		]);
    }
	
	
	// For update Sales data
	public function actionUpdate($id=''){
		$model = $this->findModel($id);
		$modelProduct = new ProductOf();
		$booksData = $modelProduct->getBooks();
		$productsData = $modelProduct->getProducts();
		if(!empty($_POST['Sales'])){
			$model->attributes = $_POST['Sales'];
			$model->updated_on = new \yii\db\Expression('now()');
			$model->updated_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/sales']);
			}
		}
		return $this->render('update', [
				'model' => $model,
				'booksData' => $booksData,
				'productsData' => $productsData,
				'id' => $id
		]);
    }
	
	// For get Sales data from id
	protected function findModel($id) {
        if (($model = Sales::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

}
