<?php
namespace backend\controllers;

use Yii;
use yii\web\NotFoundHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\helpers\Security;
use common\models\User;
use backend\models\PurchaseOrder;
use backend\models\ProductOf;
use backend\models\Utility;

/**
 * PurchaseOrder controller
 */
class PurchaseOrderController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['update', 'index', 'create'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                // 'actions' => [
                    // 'logout' => ['post'],
                // ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    /**
     * Displays PurchaseOrder listing.
     *
     * @return string
     */
    public function actionIndex(){
        $searchModel = new PurchaseOrder();
		$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
		
        return $this->render('index', [
				'searchModel' => $searchModel,
				'dataProvider' => $dataProvider
		]);
    }
	
	// For create PurchaseOrder
	public function actionCreate(){
		$model = new PurchaseOrder();
		$modelProduct = new ProductOf();
		$booksData = $modelProduct->getBooks();
		$productsData = $modelProduct->getProducts();
		if(!empty($_POST['PurchaseOrder'])){
			$model->attributes = $_POST['PurchaseOrder'];
			$model->created_on = new \yii\db\Expression('now()');
			$model->created_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/purchase-order']);
			}
		}		
        return $this->render('create', [
				'model' => $model,
				'booksData' => $booksData,
				'productsData' => $productsData
		]);
    }
	
	
	// For update PurchaseOrder data
	public function actionUpdate($id=''){
		$model = $this->findModel($id);
		$modelProduct = new ProductOf();
		$booksData = $modelProduct->getBooks();
		$productsData = $modelProduct->getProducts();
		if(!empty($_POST['PurchaseOrder'])){
			$model->attributes = $_POST['PurchaseOrder'];
			$model->updated_on = new \yii\db\Expression('now()');
			$model->updated_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/purchase-order']);
			}
		}
		return $this->render('update', [
				'model' => $model,
				'booksData' => $booksData,
				'productsData' => $productsData,
				'id' => $id
		]);
    }
	
	// For get PurchaseOrder data from id
	protected function findModel($id) {
        if (($model = PurchaseOrder::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

}
