<?php
namespace backend\controllers;

use Yii;
use yii\web\NotFoundHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\helpers\Security;
use common\models\User;
use backend\models\ProductOf;
use backend\models\Purchase;
use backend\models\Utility;

/**
 * Purchase controller
 */
class PurchaseController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['update', 'index', 'create'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                // 'actions' => [
                    // 'logout' => ['post'],
                // ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    /**
     * Displays Purchase listing.
     *
     * @return string
     */
    public function actionIndex(){
        $searchModel = new Purchase();
		$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
		
        return $this->render('index', [
				'searchModel' => $searchModel,
				'dataProvider' => $dataProvider
		]);
    }
	
	// For create Purchase
	public function actionCreate(){
		$model = new Purchase();
		$modelProduct = new ProductOf();
		$booksData = $modelProduct->getBooks();
		$productsData = $modelProduct->getProducts();
		if(!empty($_POST['Purchase'])){
			$model->attributes = $_POST['Purchase'];
			$model->created_on = new \yii\db\Expression('now()');
			$model->created_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/purchase']);
			}
		}		
        return $this->render('create', [
				'model' => $model,
				'booksData' => $booksData,
				'productsData' => $productsData
		]);
    }
	
	
	// For update Purchase data
	public function actionUpdate($id=''){
		$model = $this->findModel($id);
		$modelProduct = new ProductOf();
		$booksData = $modelProduct->getBooks();
		$productsData = $modelProduct->getProducts();
		if(!empty($_POST['Purchase'])){
			$model->attributes = $_POST['Purchase'];
			$model->updated_on = new \yii\db\Expression('now()');
			$model->updated_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/purchase']);
			}
		}
		return $this->render('update', [
				'model' => $model,
				'productsData' => $productsData,
				'booksData' => $booksData,
				'id' => $id
		]);
    }
	
	// For get Purchase data from id
	protected function findModel($id) {
        if (($model = Purchase::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

}
