<?php
namespace backend\controllers;

use Yii;
use yii\web\NotFoundHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\helpers\Security;
use common\models\User;
use backend\models\ProductMaster;
use backend\models\ProductType;
use backend\models\ProductCategory;
use backend\models\ProductOf;
use backend\models\ProductPackingUnit;
use backend\models\ProductComposition;
use backend\models\ProductUsedFor;
use backend\models\Utility;

/**
 * ProductMaster controller
 */
class ProductMasterController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['index', 'type', 'category', 'product-of', 'composition', 'used-for', 'packing-unit','create-type', 'create-category', 'create-product-of', 'create-composition', 'create-used-for', 'create-packing-unit', 'create', 'update'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                // 'actions' => [
                    // 'logout' => ['post'],
                // ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    /**
     * Displays Products listing.
     *
     * @return string
     */
    public function actionIndex(){
        $searchModel = new ProductMaster();
		$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
		
        return $this->render('index', [
				'searchModel' => $searchModel,
				'dataProvider' => $dataProvider
		]);
    }
	
	public function actionCreate(){
        $model = new ProductMaster();
		$categoryData = $model->getCategoryData();
		$productTypeData = $model->getProductType();
		$productOfData = $model->getProductOf();
		$compositionData = $model->getCompositionData();
		$productUsedForData = $model->getProductUsedFor();
		$productUnitData = $model->getProductPackingUnit();
		if(!empty($_POST['ProductMaster'])){
			$model->attributes = $_POST['ProductMaster'];
			$model->image = !empty($_POST['upload_file']) ? $_POST['upload_file'] : '';
			$model->created_on = new \yii\db\Expression('now()');
			$model->created_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/product-master']);
			}
		}		
        return $this->render('create', [
				'model' => $model,
				'productUsedForData' => $productUsedForData,
				'productUnitData' => $productUnitData,
				'categoryData' => $categoryData,
				'productTypeData' => $productTypeData,
				'productOfData' => $productOfData,
				'compositionData' => $compositionData
		]);
    }
	
	public function actionUpdate($id=""){
        $model = $this->findModel($id);
		$modelPro = new ProductMaster();
		$categoryData = $modelPro->getCategoryData();
		$productTypeData = $modelPro->getProductType();
		$productOfData = $modelPro->getProductOf();
		$compositionData = $modelPro->getCompositionData();
		$productUsedForData = $modelPro->getProductUsedFor();
		$productUnitData = $modelPro->getProductPackingUnit();
		if(!empty($_POST['ProductMaster'])){
			$model->attributes = $_POST['ProductMaster'];
			$model->image = !empty($_POST['upload_file']) ? $_POST['upload_file'] : '';
			$model->updated_on = new \yii\db\Expression('now()');
			$model->updated_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/product-master']);
			}
		}
		return $this->render('update', [
				'model' => $model,
				'productUsedForData' => $productUsedForData,
				'productUnitData' => $productUnitData,
				'categoryData' => $categoryData,
				'productTypeData' => $productTypeData,
				'productOfData' => $productOfData,
				'compositionData' => $compositionData,
				'id' => $id
		]);
    }
	
	/**
     * Displays Product Type listing.
     *
     * @return string
     */
    public function actionComposition(){
        $searchModel = new ProductComposition();
		$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
		
        return $this->render('composition', [
				'searchModel' => $searchModel,
				'dataProvider' => $dataProvider
		]);
    }
	
	public function actionProductOf(){
        $searchModel = new ProductOf();
		$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
		
        return $this->render('product-of', [
				'searchModel' => $searchModel,
				'dataProvider' => $dataProvider
		]);
    }
	
	public function actionCategory(){
        $searchModel = new ProductCategory();
		$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
		
        return $this->render('category', [
				'searchModel' => $searchModel,
				'dataProvider' => $dataProvider
		]);
    }
	
	public function actionUsedFor(){
        $searchModel = new ProductUsedFor();
		$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
		
        return $this->render('used-for', [
				'searchModel' => $searchModel,
				'dataProvider' => $dataProvider
		]);
    }
	
	public function actionPackingUnit(){
        $searchModel = new ProductPackingUnit();
		$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
		
        return $this->render('packing-unit', [
				'searchModel' => $searchModel,
				'dataProvider' => $dataProvider
		]);
    }
	// For product type listing
	public function actionType(){
        $searchModel = new ProductType();
		$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
		
        return $this->render('type', [
				'searchModel' => $searchModel,
				'dataProvider' => $dataProvider
		]);
    }
	
	// For create/update product type
	public function actionCreateType($id=""){
		$model = new ProductType();
		if(!empty($id)){
			$model = ProductType::findOne($id);
		}
		if(!empty($_POST['ProductType'])){
			$model->attributes = $_POST['ProductType'];
			$model->created_on = new \yii\db\Expression('now()');
			$model->created_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/product-master/type']);
			}
		}		
        return $this->render('create-type', [
				'model' => $model,
				'id' => $id
		]);
    }
	
	public function actionCreateCategory($id=""){
		$model = new ProductCategory();
		if(!empty($id)){
			$model = ProductCategory::findOne($id);
		}
		if(!empty($_POST['ProductCategory'])){
			$model->attributes = $_POST['ProductCategory'];
			$model->created_on = new \yii\db\Expression('now()');
			$model->created_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/product-master/category']);
			}
		}		
        return $this->render('create-category', [
				'model' => $model,
				'id' => $id
		]);
    }
	
	public function actionCreateComposition($id=""){
		$model = new ProductComposition();
		if(!empty($id)){
			$model = ProductComposition::findOne($id);
		}
		if(!empty($_POST['ProductComposition'])){
			$model->attributes = $_POST['ProductComposition'];
			$model->created_on = new \yii\db\Expression('now()');
			$model->created_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/product-master/composition']);
			}
		}		
        return $this->render('create-composition', [
				'model' => $model,
				'id' => $id
		]);
    }
	
	public function actionCreatePackingUnit($id=""){
		$model = new ProductPackingUnit();
		if(!empty($id)){
			$model = ProductPackingUnit::findOne($id);
		}
		if(!empty($_POST['ProductPackingUnit'])){
			$model->attributes = $_POST['ProductPackingUnit'];
			$model->created_on = new \yii\db\Expression('now()');
			$model->created_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/product-master/packing-unit']);
			}
		}		
        return $this->render('create-packing-unit', [
				'model' => $model,
				'id' => $id
		]);
    }
	
	public function actionCreateProductOf($id=""){
		$model = new ProductOf();
		$booksData = $model->getBooks();
		if(!empty($id)){
			$model = ProductOf::findOne($id);
		}
		if(!empty($_POST['ProductOf'])){
			$model->attributes = $_POST['ProductOf'];
			$model->created_on = new \yii\db\Expression('now()');
			$model->created_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/product-master/product-of']);
			}
		}		
        return $this->render('create-product-of', [
				'model' => $model,
				'booksData' => $booksData,
				'id' => $id
		]);
    }
	
	public function actionCreateUsedFor($id=""){
		$model = new ProductUsedFor();
		if(!empty($id)){
			$model = ProductUsedFor::findOne($id);
		}
		if(!empty($_POST['ProductUsedFor'])){
			$model->attributes = $_POST['ProductUsedFor'];
			$model->created_on = new \yii\db\Expression('now()');
			$model->created_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/product-master/used-for']);
			}
		}		
        return $this->render('create-used-for', [
				'model' => $model,
				'id' => $id
		]);
    }
	
	
	// For get ProductMaster data from id
	protected function findModel($id) {
        if (($model = ProductMaster::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

}
