<?php
namespace backend\controllers;

use Yii;
use yii\web\NotFoundHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\helpers\Security;
use common\models\User;
use backend\models\Ownmaster;
use backend\models\Utility;

/**
 * Ownmaster controller
 */
class OwnmasterController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['update', 'index', 'create', 'getpackage'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                // 'actions' => [
                    // 'logout' => ['post'],
                // ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    /**
     * Displays ownmaster listing.
     *
     * @return string
     */
    public function actionIndex(){
        $searchModel = new Ownmaster();
		$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
		
        return $this->render('index', [
				'searchModel' => $searchModel,
				'dataProvider' => $dataProvider
		]);
    }
	
	// For create ownmaster
	public function actionCreate(){
		$model = new Ownmaster();
		$utility = new Utility();
		$stateData = $utility->getStates();
		$error = "";
		if(!empty($_POST['Ownmaster'])){
			$model->attributes = $_POST['Ownmaster'];
			$email_id = !empty($_POST['Ownmaster']['email_id']) ? $_POST['Ownmaster']['email_id'] : '';
			$userData = User::find()->where(['email' => $email_id, 'user_type' => 1])->one();
			if(empty($userData)){
				$userModel = new User();
				$newPassword = !empty($_POST['Ownmaster']['password']) ? $_POST['Ownmaster']['password'] : '';
				$userModel->password_hash = Security::generatePasswordHash($newPassword);
				$userModel->new_password_hash = $userModel->password_hash;
				$userModel->confirm_password_hash = $userModel->password_hash;
				$userModel->auth_key = $userModel->password_hash;
				$userModel->email = $email_id;
				$userModel->user_type = 1;
				$userModel->status = 'Active';
				$userModel->created_by = Yii::$app->user->identity->id;
				$userModel->save();
				if(!empty($_FILES['Ownmaster']['name']['logo_file']) && !empty($_FILES['Ownmaster']['tmp_name']['logo_file'])){
					$filePath = '../../uploads/';
					$file_name = time().$_FILES['Ownmaster']['name']['logo_file'];
					$file_tmp_name = $_FILES['Ownmaster']['tmp_name']['logo_file'];
					$uploadfile = $filePath . $file_name;
					move_uploaded_file($file_tmp_name, $uploadfile);
					$model->logo_file = $file_name;
				}
				$model->password = $userModel->password_hash;
				$model->confirm_password = $userModel->password_hash;
				$model->user_id = $userModel->id;
				$model->created_on = new \yii\db\Expression('now()');
				$model->created_by = Yii::$app->user->identity->id;
				if ($model->validate()) {
					$model->save();
					// For send email
					$to_name = ''; 
					$subject = 'Registration Details - Maprole';
					$message = 'Dear '.$email_id;
					$message .= '<br><p>Your account has been created on Maprole, Please login with the following details :- <p>';
					$message .= '<p>Login Url:- '.BASE_URL.'login<p>';
					$message .= '<p>Email Id :- '.$email_id.'<p>';
					$message .= '<p>Password :- '.$newPassword.'<p>';
					$message .= '<br><p>Thanks & Regards,<br> Maprole Team<p>';
					// Utility::sendEmail($email_id,$to_name,$subject,$message);
					
					return $this->redirect(['/ownmaster']);
				}
			}else{
				$error = "Email id is already exist.";
				return $this->render('create', [
						'model' => $model,
						'stateData' => $stateData,
						'error' => $error
				]);
			}		
		}		
        return $this->render('create', [
				'model' => $model,
				'stateData' => $stateData,
				'error' => $error
		]);
    }
	
	
	// For update ownmaster data
	public function actionUpdate($id=''){
		$model = $this->findModel($id);
		$utility = new Utility();
		$stateData = $utility->getStates();
		if(!empty($_POST['Ownmaster'])){
			$model->attributes = $_POST['Ownmaster'];
			$model->updated_on = new \yii\db\Expression('now()');
			$model->updated_by = Yii::$app->user->identity->id;
			
			$email_id = !empty($_POST['Ownmaster']['email_id']) ? $_POST['Ownmaster']['email_id'] : '';
			$userModel = User::find()->where(['email' => $email_id, 'user_type' => 1])->one();
			if(!empty($userModel)){
				$newPassword = !empty($_POST['Ownmaster']['password']) ? $_POST['Ownmaster']['password'] : '';
				if($newPassword != $userModel->password_hash){
					$userModel->password_hash = Security::generatePasswordHash($newPassword);
					$userModel->new_password_hash = $userModel->password_hash;
					$userModel->confirm_password_hash = $userModel->password_hash;
					$userModel->updated_by = Yii::$app->user->identity->id;
					$userModel->save();
				}
			}
			$model->logo_file = !empty($_POST['logo_file']) ? $_POST['logo_file'] : '';
			if(!empty($_FILES['Ownmaster']['name']['logo_file']) && !empty($_FILES['Ownmaster']['tmp_name']['logo_file'])){
				$filePath = '../../uploads/';
				$file_name = time().$_FILES['Ownmaster']['name']['logo_file'];
				$file_tmp_name = $_FILES['Ownmaster']['tmp_name']['logo_file'];
				$uploadfile = $filePath . $file_name;
				move_uploaded_file($file_tmp_name, $uploadfile);
				$model->logo_file = $file_name;
			}
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/ownmaster']);
			}
		}
		return $this->render('update', [
				'model' => $model,
				'id' => $id,
				'stateData' => $stateData
		]);
    }
	
	// For get ownmaster data from id
	protected function findModel($id) {
        if (($model = Ownmaster::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
	
	public function actionGetpackage(){
		if(!empty($_GET['package_id'])){
			$utility = new Utility();
			return $utility->getPackageData($_GET['package_id']);
		}
	}

}
