<?php
namespace backend\controllers;

use Yii;
use yii\web\NotFoundHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\helpers\Security;
use common\models\User;
use backend\models\Utility;

/**
 * File controller
 */
class FileController extends Controller
{
    /**
     * {@inheritdoc}
     */
	public $enableCsrfValidation = false;
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['uploadfile'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                // 'actions' => [
                    // 'logout' => ['post'],
                // ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    /**
     * Displays areamaster listing.
     *
     * @return string
     */
    public function actionUploadfile(){
        if(!empty($_FILES['file']['name']) && !empty($_FILES['file']['tmp_name'])){
			$filePath = "../../uploads/";
			$fileName = time().$_FILES['file']['name'];
			$fileTmp = $_FILES['file']['tmp_name'];
			move_uploaded_file($fileTmp, $filePath.$fileName);
			return $fileName;
		}
    }
	
}
