<?php
namespace backend\controllers;

use Yii;
use yii\web\NotFoundHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\helpers\Security;
use common\models\User;
use backend\models\ExpensesMaster;
use backend\models\Utility;

/**
 * ExpensesMaster controller
 */
class ExpensesMasterController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['update', 'index', 'create'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                // 'actions' => [
                    // 'logout' => ['post'],
                // ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    /**
     * Displays ExpensesMaster listing.
     *
     * @return string
     */
    public function actionIndex(){
        $searchModel = new ExpensesMaster();
		$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
		
        return $this->render('index', [
				'searchModel' => $searchModel,
				'dataProvider' => $dataProvider
		]);
    }
	
	// For create ExpensesMaster
	public function actionCreate(){
		$model = new ExpensesMaster();
		if(!empty($_POST['ExpensesMaster'])){
			$model->attributes = $_POST['ExpensesMaster'];
			$model->created_on = new \yii\db\Expression('now()');
			$model->created_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/expenses-master']);
			}
		}		
        return $this->render('create', [
				'model' => $model
		]);
    }
	
	
	// For update ExpensesMaster data
	public function actionUpdate($id=''){
		$model = $this->findModel($id);
		if(!empty($_POST['ExpensesMaster'])){
			$model->attributes = $_POST['ExpensesMaster'];
			$model->updated_on = new \yii\db\Expression('now()');
			$model->updated_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/expenses-master']);
			}
		}
		return $this->render('update', [
				'model' => $model,
				'id' => $id
		]);
    }
	
	// For get ExpensesMaster data from id
	protected function findModel($id) {
        if (($model = ExpensesMaster::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

}
