<?php
namespace backend\controllers;

use Yii;
use yii\web\NotFoundHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\helpers\Security;
use common\models\User;
use backend\models\Expenses;
use backend\models\Utility;

/**
 * Expenses controller
 */
class ExpensesController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['update', 'index', 'create'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                // 'actions' => [
                    // 'logout' => ['post'],
                // ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    /**
     * Displays Expenses listing.
     *
     * @return string
     */
    public function actionIndex(){
        $searchModel = new Expenses();
		$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
		
        return $this->render('index', [
				'searchModel' => $searchModel,
				'dataProvider' => $dataProvider
		]);
    }
	
	// For create Expenses
	public function actionCreate(){
		$model = new Expenses();
		$expensesData = $model->getExpenses();
		if(!empty($_POST['Expenses'])){
			$model->attributes = $_POST['Expenses'];
			$model->created_on = new \yii\db\Expression('now()');
			$model->created_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/expenses']);
			}
		}		
        return $this->render('create', [
				'model' => $model,
				'expensesData' => $expensesData
		]);
    }
	
	
	// For update Expenses data
	public function actionUpdate($id=''){
		$model = $this->findModel($id);
		$modelExp = new Expenses();
		$expensesData = $modelExp->getExpenses();
		if(!empty($_POST['Expenses'])){
			$model->attributes = $_POST['Expenses'];
			$model->updated_on = new \yii\db\Expression('now()');
			$model->updated_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/expenses']);
			}
		}
		return $this->render('update', [
				'model' => $model,
				'expensesData' => $expensesData,
				'id' => $id
		]);
    }
	
	// For get Expenses data from id
	protected function findModel($id) {
        if (($model = Expenses::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

}
