<?php
namespace backend\controllers;

use Yii;
use yii\web\NotFoundHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\helpers\Security;
use common\models\User;
use backend\models\CustomerMaster;
use backend\models\StaffMaster;
use backend\models\Utility;

/**
 * CustomerMaster controller
 */
class CustomerMasterController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['update', 'index', 'create'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                // 'actions' => [
                    // 'logout' => ['post'],
                // ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    /**
     * Displays CustomerMaster listing.
     *
     * @return string
     */
    public function actionIndex(){
        $searchModel = new CustomerMaster();
		$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
		
        return $this->render('index', [
				'searchModel' => $searchModel,
				'dataProvider' => $dataProvider
		]);
    }
	
	// For create CustomerMaster
	public function actionCreate(){
		$model = new CustomerMaster();
		$modelStaff = new StaffMaster();
		$areaData = $modelStaff->getAreaData();
		$staffData = $modelStaff->getStaffData();
		$customerType = $model->getCustomerType();
		if(!empty($_POST['CustomerMaster'])){
			$model->attributes = $_POST['CustomerMaster'];
			
			$email = !empty($_POST['CustomerMaster']['email_id']) ? $_POST['CustomerMaster']['email_id'] : '';
			$userData = User::find()->where(['email' => $email, 'user_type' => 3])->one();
			if(empty($userData)){			
				$userModel = new User();
				$pass = !empty($_POST['CustomerMaster']['password']) ? $_POST['CustomerMaster']['password'] : '';
				$userModel->password_hash = Security::generatePasswordHash($pass);
				$userModel->new_password_hash = $userModel->password_hash;
				$userModel->confirm_password_hash = $userModel->password_hash;
				$userModel->auth_key = $userModel->password_hash;
				$userModel->email = $email;
				$userModel->user_type = 3;
				$userModel->status = 'Active';
				$userModel->created_by = Yii::$app->user->identity->id;
				$userModel->save();
				
				$model->password = $userModel->password_hash;
				$model->confirm_password = $userModel->password_hash;
				$model->user_id = $userModel->id;
				$model->photo = !empty($_POST['upload_file']) ? $_POST['upload_file'] : '';
				$model->created_on = new \yii\db\Expression('now()');
				$model->created_by = Yii::$app->user->identity->id;
				if ($model->validate()) {
					$model->save();
					return $this->redirect(['/customer-master']);
				}
			}else{
				$error = "Email id is already exist.";
				return $this->render('create', [
						'model' => $model,
						'customerType' => $customerType,
						'staffData' => $staffData,
						'areaData' => $areaData,
						'error' => $error
				]);
			}	
		}		
        return $this->render('create', [
				'model' => $model,
				'customerType' => $customerType,
				'staffData' => $staffData,
				'areaData' => $areaData
		]);
    }
	
	
	// For update CustomerMaster data
	public function actionUpdate($id=''){
		$model = $this->findModel($id);
		$modelCustomer = new CustomerMaster();
		$modelStaff = new StaffMaster();
		$staffData = $modelStaff->getStaffData();
		$areaData = $modelStaff->getAreaData();
		$customerType = $modelCustomer->getCustomerType();
		if(!empty($_POST['CustomerMaster'])){
			$model->attributes = $_POST['CustomerMaster'];
			
			$email = !empty($_POST['CustomerMaster']['email_id']) ? $_POST['CustomerMaster']['email_id'] : '';
			$userModel = User::find()->where(['email' => $email, 'user_type' => 3])->one();
			if(!empty($userModel)){			
				$newPassword = !empty($_POST['CustomerMaster']['password']) ? $_POST['CustomerMaster']['password'] : '';
				if($newPassword != $userModel->password_hash){
					$userModel->password_hash = Security::generatePasswordHash($newPassword);
					$userModel->new_password_hash = $userModel->password_hash;
					$userModel->confirm_password_hash = $userModel->password_hash;
					$userModel->auth_key = $userModel->password_hash;
					$userModel->save();
					
					$model->password = $userModel->password_hash;
					$model->confirm_password = $userModel->password_hash;
				}
			}
			
			$model->photo = !empty($_POST['upload_file']) ? $_POST['upload_file'] : '';
			$model->updated_on = new \yii\db\Expression('now()');
			$model->updated_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/customer-master']);
			}
		}
		return $this->render('update', [
				'model' => $model,
				'customerType' => $customerType,
				'areaData' => $areaData,
				'staffData' => $staffData,
				'id' => $id
		]);
    }
	
	// For get CustomerMaster data from id
	protected function findModel($id) {
        if (($model = CustomerMaster::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

}
