<?php
namespace backend\controllers;

use Yii;
use yii\web\NotFoundHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\helpers\Security;
use common\models\User;
use backend\models\CaseInHand;
use backend\models\VehicleNumber;
use backend\models\Utility;

/**
 * CaseInHand controller
 */
class CaseInHandController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['update', 'index', 'create'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                // 'actions' => [
                    // 'logout' => ['post'],
                // ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    /**
     * Displays CaseInHand listing.
     *
     * @return string
     */
    public function actionIndex(){
        $searchModel = new CaseInHand();
		$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
		
        return $this->render('index', [
				'searchModel' => $searchModel,
				'dataProvider' => $dataProvider
		]);
    }
	
	// For create CaseInHand
	public function actionCreate(){
		$model = new CaseInHand();
		$modelV = new VehicleNumber();
		$owners = $modelV->getVehicleOwner();
		if(!empty($_POST['CaseInHand'])){
			$model->attributes = $_POST['CaseInHand'];
			$model->created_on = new \yii\db\Expression('now()');
			$model->created_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/case-in-hand']);
			}
		}		
        return $this->render('create', [
				'owners' => $owners,
				'model' => $model
		]);
    }
	
	
	// For update CaseInHand data
	public function actionUpdate($id=''){
		$model = $this->findModel($id);
		$modelV = new VehicleNumber();
		$owners = $modelV->getVehicleOwner();
		if(!empty($_POST['CaseInHand'])){
			$model->attributes = $_POST['CaseInHand'];
			$model->updated_on = new \yii\db\Expression('now()');
			$model->updated_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/case-in-hand']);
			}
		}
		return $this->render('update', [
				'model' => $model,
				'owners' => $owners,
				'id' => $id
		]);
    }
	
	// For get CaseInHand data from id
	protected function findModel($id) {
        if (($model = CaseInHand::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

}
