<?php
namespace backend\controllers;

use Yii;
use yii\web\NotFoundHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\helpers\Security;
use common\models\User;
use backend\models\BankMaster;
use backend\models\ProductOf;
use backend\models\Utility;

/**
 * BankMaster controller
 */
class BankMasterController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['update', 'index', 'create'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                // 'actions' => [
                    // 'logout' => ['post'],
                // ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    /**
     * Displays BankMaster listing.
     *
     * @return string
     */
    public function actionIndex(){
        $searchModel = new BankMaster();
		$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
		
        return $this->render('index', [
				'searchModel' => $searchModel,
				'dataProvider' => $dataProvider
		]);
    }
	
	// For create BankMaster
	public function actionCreate(){
		$model = new BankMaster();
		$modelP = new ProductOf();
		$books = $modelP->getBooks();
		if(!empty($_POST['BankMaster'])){
			$model->attributes = $_POST['BankMaster'];
			$model->created_on = new \yii\db\Expression('now()');
			$model->created_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/bank-master']);
			}
		}		
        return $this->render('create', [
				'model' => $model,
				'books' => $books
		]);
    }
	
	
	// For update BankMaster data
	public function actionUpdate($id=''){
		$model = $this->findModel($id);
		$modelP = new ProductOf();
		$books = $modelP->getBooks();
		if(!empty($_POST['BankMaster'])){
			$model->attributes = $_POST['BankMaster'];
			$model->updated_on = new \yii\db\Expression('now()');
			$model->updated_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/bank-master']);
			}
		}
		return $this->render('update', [
				'model' => $model,
				'books' => $books,
				'id' => $id
		]);
    }
	
	// For get BankMaster data from id
	protected function findModel($id) {
        if (($model = BankMaster::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

}
