<?php
namespace backend\controllers;

use Yii;
use yii\web\NotFoundHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\helpers\Security;
use common\models\User;
use backend\models\Areamaster;
use backend\models\Utility;

/**
 * Areamaster controller
 */
class AreamasterController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['update', 'index', 'create'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                // 'actions' => [
                    // 'logout' => ['post'],
                // ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    /**
     * Displays areamaster listing.
     *
     * @return string
     */
    public function actionIndex(){
        $searchModel = new Areamaster();
		$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
		
        return $this->render('index', [
				'searchModel' => $searchModel,
				'dataProvider' => $dataProvider
		]);
    }
	
	// For create areamaster
	public function actionCreate(){
		$model = new Areamaster();
		if(!empty($_POST['Areamaster'])){
			$model->attributes = $_POST['Areamaster'];
			$model->applicable_to = implode(",", $_POST['Areamaster']['applicable_to']);
			$model->created_on = new \yii\db\Expression('now()');
			$model->created_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/areamaster']);
			}
		}	
        return $this->render('create', [
				'model' => $model
		]);
    }
	
	
	// For update areamaster data
	public function actionUpdate($id=''){
		$model = $this->findModel($id);
		$model->applicable_to = !empty($model->applicable_to) ? explode(",", $model->applicable_to) : '';
		if(!empty($_POST['Areamaster'])){
			$model->attributes = $_POST['Areamaster'];
			$model->applicable_to = implode(",", $_POST['Areamaster']['applicable_to']);
			$model->updated_on = new \yii\db\Expression('now()');
			$model->updated_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				return $this->redirect(['/areamaster']);
			}
		}
		return $this->render('update', [
				'model' => $model,
				'id' => $id
		]);
    }
	
	// For get areamaster data from id
	protected function findModel($id) {
        if (($model = Areamaster::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

}
